<?php
/**
 * Plugin Name: Novelist - Second Buy Section
 * Plugin URI: https://www.nosegraze.com
 * Description: Adds a second "Puchase Links" box to the layout builder.
 * Version: 1.0
 * Author: Nose Graze
 * Author URI: https://www.nosegraze.com
 * License: GPL2
 *
 * @package   novelist-second-buy
 * @copyright Copyright (c) 2016, Nose Graze Ltd.
 * @license   GPL2+
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * Add to Book Layout
 *
 * Add the field to the available book layout options.
 *
 * @param array $fields
 *
 * @since 1.0
 * @return array
 */
function novelist_second_buy_field( $fields ) {
	$fields['purchase_links_2'] = array(
		'name'        => __( 'Purchase Links #2', 'novelist-second-buy' ),
		'placeholder' => '[purchaselinks]',
		'label'       => sprintf( __( '<strong>Buy the Book:</strong> %s', 'novelist-second-buy' ), '[purchaselinks]' ),
		'linebreak'   => 'on'
	);

	return $fields;
}

add_filter( 'novelist/book/available-fields', 'novelist_second_buy_field' );

/**
 * Render Second Purchase Links
 *
 * @param string        $value          Current value for this field
 * @param string        $key            The key that is being filtered
 * @param array         $all_fields     All available book fields
 * @param array         $enabled_fields Array of the enabled book fields
 * @param Novelist_Book $book           Object for the current book
 *
 * @since 1.0
 * return string
 */
function novelist_render_second_buy_field( $value, $key, $all_fields, $enabled_fields, $book ) {

	$value = $book->get_formatted_purchase_links();

	return $value;

}

add_filter( 'novelist/book/pre-render/purchase_links_2', 'novelist_render_second_buy_field', 10, 5 );